# build this image from top level of the release package
FROM docker.io/postgres:16-trixie

# deploy deb packages
COPY ./dist/trixie/3djuump-infinite-pgplugin-3d-16-4-0_4.1.24.7186-9a016eff14406b1e_amd64_trixie*.deb /tmp/
COPY ./dist/trixie/3djuump-infinite-pgplugin-range-operators-16-4-0_4.1.24.7186-9a016eff14406b1e_amd64_trixie*.deb /tmp/
COPY ./dist/trixie/3djuump-infinite-pgplugin-fdw-16-5-0_4.1.24.7186-9a016eff14406b1e_amd64_trixie*.deb /tmp/

# update apt
RUN apt update
RUN apt --assume-yes upgrade

# configure locale
RUN apt --assume-yes install locales
RUN echo "en_US.UTF-8 UTF-8" >> /etc/locale.gen
RUN locale-gen
ENV LANG=en_US.UTF-8
ENV LANGUAGE=en_US:en
ENV LC_ALL=en_US.UTF-8
RUN export

# install deb packages
ARG DEBIAN_FRONTEND=noninteractive
RUN dpkg --force-all -i /tmp/*.deb

# install dependencies
RUN apt --assume-yes -f install

# remove deb packages
RUN rm -rf /tmp/*.deb
RUN apt clean
